import 'package:flutter/material.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import '../../../../../infrastructure/services/app_helpers.dart';

class DeliveryInfoWidget extends StatelessWidget {
  final String title;
  final String textDelivery;
  final Color textColor;

  const DeliveryInfoWidget({
    super.key,
    required this.title,
    this.textColor = Style.black,
    required this.textDelivery,
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Text(
          AppHelpers.getTranslation(title),
          style: Style.interNormal(
            color: Style.black,
            size: 14,
            letterSpacing: -0.4,
          ),
        ),
        Text(
          textDelivery,
          style: Style.interNormal(
            color: textColor,
            size: 14,
            letterSpacing: -0.4,
          ),
        ),
      ],
    );
  }
}
